<?php
/**
* Shortcode Roadmap Item
*/

if( ! defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly
	
/**
* Liquid_Events_Shortcode
*/
class LE_Table_Cell extends Liquid_Events_Shortcode {

	/**
	 * Construct
	 * @method __construct
	 */
	public function __construct() {

		// Properties
		$this->slug            = 'le_schedule_table_cell';
		$this->title           = esc_html__( 'Schedule Table Cell', 'liquid-events' );
		$this->description     = esc_html__( 'Add Schedule Table Cell', 'liquid-events' );
		$this->icon            = 'fa fa-calendar-plus-o';
		$this->as_child        = array( 'only' => 'le_schedule_table' );

		parent::__construct();
	}

	public function get_params() {
		
		$this->params = array(
			
			array(
				'type'          => 'textfield',
				'param_name'	=> 'title',
				'heading'		=> esc_html__( 'Title', 'one-core' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
				'admin_label'	=> true
			),
			array(
				'type'             => 'textfield',
				'param_name'	   => 'info',
				'description'      => esc_html__( 'Add name/couch/trainer/teacher', 'liquid-events' ),
				'edit_field_class' => 'vc_col-sm-6',
				'heading'		   => esc_html__( 'Info', 'one-core' ),
			),
			array(
				'type'             => 'textfield',
				'param_name'	   => 'category',
				'description'      => esc_html__( 'Add category for this cell', 'liquid-events' ),
				'heading'		   => esc_html__( 'Category', 'one-core' ),
			),
			array(
				'type'       => 'textarea_html',
				'param_name' => 'content',
				'heading'    => esc_html__( 'Text', 'liquid-events' ),
				'holder'     => 'div'
			),
			array(
				'type'       => 'dropdown',
				'param_name' => 'day',
				'heading'    => esc_html__( 'Day of the Week', 'liquid-events' ),
				'value' => array(
					esc_html__( 'Sunday', 'liquid-events' )    => 'Sunday',
					esc_html__( 'Monday', 'liquid-events' )    => 'Monday',
					esc_html__( 'Tuesday', 'liquid-events' )   => 'Tuesday',
					esc_html__( 'Wednesday', 'liquid-events' ) => 'Wednesday',
					esc_html__( 'Thursday', 'liquid-events' )  => 'Thursday',
					esc_html__( 'Friday', 'liquid-events' )    => 'Friday',
					esc_html__( 'Saturday', 'liquid-events' )  => 'Saturday',
				),
				'admin_label' => true,
			),
			array(
				'type'             => 'textfield',
				'param_name'	   => 'from_time',
				'heading'		   => esc_html__( 'From Time', 'liquid-events' ),
				'description'      => esc_html__( 'Add From time for ex. 08:00', 'liquid-events' ),
				'edit_field_class' => 'vc_col-sm-6 vc_column-with-padding',
				'admin_label'	   => true,
				'value'            => '08:00'
			),
			array(
				'type'             => 'textfield',
				'param_name'	   => 'to_time',
				'heading'		   => esc_html__( 'To Time', 'liquid-events' ),
				'edit_field_class' => 'vc_col-sm-6',
				'description'      => esc_html__( 'Add From time for ex. 10:00', 'liquid-events' ),
				'admin_label'	   => true,
				'value'            => '10:00',
			),
			array(
				'type'             => 'textfield',
				'param_name'	   => 'btn_label',
				'heading'		   => esc_html__( 'Button label', 'liquid-events' ),
				'edit_field_class' => 'vc_col-sm-6',
				'description'      => esc_html__( 'Add button label', 'liquid-events' ),
			),						
			array(
				'type'             => 'vc_link',
				'param_name'       => 'link',
				'heading'          => esc_html__( 'URL (Link)', 'one-core' ),
				'edit_field_class' => 'vc_col-sm-6',
				'description'      => esc_html__( 'Add link to button.', 'one-core' )
			),

		);
		$this->add_extras();
	
	}

	protected function get_opts() {
		
		extract( $this->atts );
		
		$opts = array();
		$opts['day'] = $day;
		$opts['time'] = $from_time . ' - ' . $to_time;
		if( !empty( $title ) ) {
			$opts['name'] = esc_html( $title );
		}
		if( !empty( $info ) ) {
			$opts['info'] = esc_html( $info );
		}
		if( !empty( $content ) ) {
			$opts['description'] = $content;
		}
		if( !empty( $btn_label ) ) {
			$opts['buttonText'] = esc_html( $btn_label );
		}
	    // Link
	    $link = ( '||' === $link ) ? '#' : $link;
	    $link = vc_build_link( $link );
	    if ( strlen( $link['url'] ) > 0 ) {
		    $opts['buttonLink'] = esc_url( $link['url'] );
	    }
		if( !empty( $category ) ) {
			$opts['category'] = esc_html( sanitize_title( $category ) );
		}

		echo 'data-st-cell=\'' . wp_json_encode( $opts ) . '\'';

	}
	
	public function render( $atts, $content = '' ) {

		global $le_cells;

		$atts = vc_map_get_attributes( $this->slug, $atts );
		$atts = $this->before_output( $atts, $content );
		$atts['_category'] = $atts['category'];

		$le_cells[]  = $atts;

		// Locate template file
		$located = $this->locate_template( $atts );

		// If no file throw error
		if ( !$located ) {
			trigger_error( sprintf( esc_html__( 'Template file is missing for `%s` shortcode. Make sure you have `%s` file in your theme folder or default folder.', 'liquid-events' ), $this->title, 'view.php' ) );
			return;
		}

		$this->atts = $atts;
		$this->atts['content'] = $content;

		// Generate Output
		ob_start();

		include $located;

		return ob_get_clean();
		
	}

	protected function generate_css() {

		$elements = array();
		extract( $this->atts );
		$id = '.' .$this->get_id();

		$this->dynamic_css_parser( $id, $elements );
	}

}
new LE_Table_Cell;