<?php
/**
* Liquid Shape Divider Options
*/

if( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

/**
 * [liquid_param_select_preview description]
 * @method liquid_param_select_preview
 * @param  [type]               $settings [description]
 * @param  [type]               $value    [description]
 * @return [type]                         [description]
 */
/*
vc_add_shortcode_param( 'css_responsive_editor', 'liquid_param_responsive_options' );
function liquid_param_responsive_options( $settings, $value ) {

	return 'Hi';

}
*/
if( ! class_exists( 'Liquid_Shape_Divider_Options' ) ) {

	class Liquid_Shape_Divider_Options  {

		/**
		 * @var array
		 */
		protected $positions = array( 'top', 'bottom' );

		function __construct() {

			if ( function_exists( 'vc_add_shortcode_param' ) ) {
				vc_add_shortcode_param( 'liquid_shape_divider', array( $this, 'shape_divider_param' ) );
			}
		}

		function shape_divider_param( $settings, $value ) {

			$label  = isset( $settings['label'] ) ? $settings['label'] : esc_html__( 'Shape Divider Options', 'ave-core' );
			$values = $this->get_shape_divider_values( $value );

			$positions = $this->positions;
			$i = 0;

			$output = '<div class="vc_css-editor vc_row vc_ui-flex-row">';
			$output .= '	<div class="vc_col-xs-12 liquid-shape-divider-tabs">';
			$output .= '		<h3 class="liquid-shape-divider-heading top active" data-target="top">' .  esc_html__( 'Top Divider', 'ave-core' )  . '</h3>';
			$output .= '		<h3 class="liquid-shape-divider-heading bottom" data-target="bottom">' .  esc_html__( 'Bottom Divider', 'ave-core' )  . '</h3>';
			$output .= '	</div>';
			
			foreach( $positions as $position ) {

				$hidden = ( $i != 0 ) ? 'hidden' : '';

				$output .= '	<div class="vc_col-xs-12 liquid_shape_divider_settings ' . $hidden . '" data-position="' . $position . '">';
				$output .= '		<div class="vc_row">';
				$output .= '			<div class="liquid_shape_divider_preview vc_col-xs-6"><div class="liquid_shape"></div></div>';
				$output .= '			<div class="vc_col-xs-6">';

				$output .= '<div class="liquid-main-responsive-wrapper ">';
				$output .= '	<div class="liquid-inner-wrap">';

				// Shape type select
				$output .= '	<label>' . esc_html__( 'Shape Type', 'ave-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-type">'
						. '			<select data-name="' . $position . '-shape-type" data-preview-target=".liquid_shape" name="' . $position . '_shape_type" class="liquid_shape_divider-type">'
						.				$this->getShapeTypeOptions( $position,  $values )
						. '			</select>'
						. '		</div>';

				// Shape divider height
				$output .= '	<label>' . esc_html__( 'Height', 'ave-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-height">'
						.			$this->getShapeHeight( $position,  $values )
						. '		</div>';

				// Shape divider backround color
				$output .= '	<label>' . esc_html__( 'Color', 'ave-core' ) . '</label>'
						. '	 	<div class="liquid_shape_divider-color">'
						.			$this->getShapeColor( $position,  $values )
						. '		</div>';

				$output .= '	</div>'; //.liquid-inner-wrap
				$output .= '</div>'; // .liquid-main-shape_divider-wrapper

				$i++;

				$output .= '			</div>'; //.vc_col-xs-6
				$output .= '		</div>'; //.row
				$output .= '	</div>'; //.vc_col-xs-12
				
			}
			$output .= '	<input name="' . $settings['param_name'] . '" class="wpb_vc_param_value  ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $value . '" />';
			$output .= '</div>'; // .liquid-shape-divider-container

			return $output;

		}

		public static function get_shape_divider_values( $value ) {
			return vc_parse_multi_attribute( $value, array( 'top_shape_type' => '', 'top_shape_color' => '', 'top_shape_height' => '', 'top_shape_width' => '', 'top_shape_flip' => '', 'top_shape_inverse' => '', 'bottom_shape_type' => '', 'bottom_shape_color' => '', 'bottom_shape_height' => '', 'bottom_shape_width' => '', 'bottom_shape_flip' => '', 'bottom_shape_inverse' => '' ) );
		}

		/**
		 * @return string
		 */
		function getShapeTypeOptions( $position, $values = array() ) {
			$output = '<option data-svg-path="" value="">' . esc_html__( 'None', 'ave-core' ) . '</option>';
			$styles = apply_filters( 'liquid_shape_divider_type_options_data', array(
				'1',
				'2',
				'3',
				'4',
				'5',
				'6',
				'7',
			) );
			foreach ( $styles as $key => $style ) {
				$output .= '<option '. selected( $style, $values[ $position . '_shape_type'] ) .' data-svg-path="' . get_template_directory_uri() . '/assets/img/svg-divider/' . $style . '.svg' . '" value="' . $style . '">' . $style  . '</option>';
			}

			return $output;
		}


		function getShapeColor( $position, $values = array() ) {

			$output = '<input type="text" data-name="' . $position . '-shape-color" name="' . $position . '_shape_color" value="' . $values[ $position . '_shape_color' ] . '" class="liquid_color-control">';

			return $output;

		}

		function getShapeHeight( $position, $values = array() ) {

			return '<div class="liquid-slider"><div class="liquid-handle ui-slider-handle"></div></div><input type="hidden" data-name="' . $position . '-shape-height" name="' . $position . '_shape_height" value="' . $values[ $position . '_shape_height' ] . '" class="liquid_shape_height-control liquid-sliderinput" >';

		}

		function getShapeWidth( $position, $values = array() ) {

			return '<div class="liquid-slider"><div class="liquid-handle ui-slider-handle"></div></div><input type="hidden" data-name="' . $position . '-shape-width" name="' . $position . '_shape_weight" value="' . $values[ $position . '_shape_weight' ] . '" class="liquid_shape_weight-control liquid-sliderinput">';

		}

		function getTopShape( $values = array() ) {
			return file_get_contents( get_template_directory() . '/assets/img/svg-divider/' . $values[ 'top_shape_type' ] . '.svg' );
		}

		function getBottomShape( $values = array() ) {
			return file_get_contents( get_template_directory() . '/assets/img/svg-divider/' . $values[ 'bottom_shape_type' ] . '.svg' );
		}


		public static function getShape( $value, $pos = 'top' ) {

			if( empty( $value ) ){
				return;
			}

			$values = Liquid_Shape_Divider_Options::get_shape_divider_values( $value );
			if( ! isset( $values[ $pos . '_shape_type' ] ) || empty( $values[ $pos . '_shape_type' ] ) ) {
				return;
			}

			$shape = $values[ $pos . '_shape_type' ];
			$svg = '';

			switch( $shape ) {

				case '1':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" width="100%" height="102"  viewBox="0 0 100 102" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
						<path transform="rotate(180 50,51.930503845214844) " d="m0,1.9305l50,100l50,-100l-100,0z"/>
					</svg>';
					break;
					
				case '2':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" version="1.1" width="100%" height="100" viewBox="0 0 100 100" preserveAspectRatio="none">
								<path d="M0 100 C40 0 60 0 100 100 Z"/>
							</svg>';
					break;
					
				case '3':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" width="100%" height="119px" viewBox="0 0 1000 119" version="1.1" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M1000 0.5 1000 118.33 0 118.33 719.760966 33.5145112z"></path>
					</svg>';
					break;
					
				case '4':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="100%" height="182" viewBox="0 0 1920 182" preserveAspectRatio="none">
						<path d="M1921.91,916.348c0.33,39.216-.34,79.431,0,118.642Q957.95,1035.5-6,1035V853c40.431,10.8,81,19.794,122.5,27.149,62.957,11.157,117.371,15.375,180.742,21.116,79.864,7.236,165.843,26.989,255.045,42.232,109.142,18.65,243.949,40.091,308.265,44.243,137.637,8.886,313.056-2.783,504.066-36.2,127.4-22.286,223.4-43.261,354.45-45.248A1569.414,1569.414,0,0,1,1921.91,916.348Z" transform="translate(0 -853)"/>
					</svg>';
					break;
					
				case '5':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="155" height="108" viewBox="0 0 155 108">
								<polygon points="1274.5 3682 1352 3790 1197 3790" transform="matrix(1 0 0 -1 -1197 3790)"/>
							</svg>';				
				break;
					
				case '6':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 68" preserveAspectRatio="none">
									<path d="m1622.3 1937.7c0 0-410.7 169.1-913.4 75.5-502.7-93.6-977.7 56.3-977.7 56.3v440h1891.1v-571.8" transform="translate(0-1977)"></path>
								</svg>';
				break;
				case '7':
					$color  = isset( $values[ $pos . '_shape_color' ] ) ? $values[ $pos . '_shape_color' ] : '#000';
					$height = isset( $values[ $pos . '_shape_height' ] ) ? $values[ $pos . '_shape_height' ] : '90';
					$svg = '<svg fill="' . $color . '" xmlns="http://www.w3.org/2000/svg" width="1440" height="9" viewBox="0 0 1440 9" preserveAspectRatio="none">
							  <path d="M1379,9.92687204e-05 C1380.76992,9.92687204e-05 1382.53969,0.677111942 1383.8855,2.03074021 L1386.94548,5.11740181 C1389.63201,7.8270408 1394.03086,7.8270408 1396.71693,5.11740181 L1399.77999,2.03074021 C1402.46652,-0.676913405 1406.86276,-0.676913405 1409.54883,2.03074021 L1412.61389,5.11740181 C1415.29842,7.8270408 1419.69712,7.8270408 1422.38334,5.11740181 L1425.44594,2.03074021 C1428.13493,-0.676913405 1432.53179,-0.676913405 1435.21785,2.03074021 L1438.28045,5.11978426 C1440.96991,7.82743787 1445.36599,7.82743787 1448.05221,5.11978426 L1451.11527,2.03074021 C1453.80196,-0.676913405 1458.19758,-0.676913405 1460.88704,2.03074021 L1463.94732,5.11740181 C1466.63324,7.8270408 1471.03225,7.8270408 1473.71862,5.11740181 L1476.78153,2.03074021 C1479.46775,-0.676913405 1483.86445,-0.676913405 1486.55314,2.03074021 L1489.61343,5.11740181 C1492.30227,7.8270408 1496.69866,7.8270408 1499.38488,5.11740181 L1502.44779,2.03074021 C1505.13416,-0.676913405 1509.53025,-0.676913405 1512.21724,2.03074021 L1515.2803,5.11740181 C1517.96667,7.8270408 1522.36291,7.8270408 1525.05175,5.11740181 L1528.11435,2.03074021 C1529.45754,0.675920717 1531.22962,-0.00228318057 1533,9.92687204e-05 L1533,9 L1379,9 L1226,9 L1073,9 L919,9 L766,9 L613,9 L460,9 L307,9 L154,9 L0,9 L0,9.92687204e-05 C1.769922,9.92687204e-05 3.53969,0.677111942 4.885496,2.03074021 L7.945476,5.11740181 C10.632006,7.8270408 15.030862,7.8270408 17.71693,5.11740181 L20.77999,2.03074021 C23.46652,-0.676913405 27.862758,-0.676913405 30.548826,2.03074021 L33.613888,5.11740181 C36.298416,7.8270408 40.697118,7.8270408 43.38334,5.11740181 L46.445938,2.03074021 C49.134932,-0.676913405 53.531786,-0.676913405 56.217854,2.03074021 L59.280452,5.11978426 C61.969908,7.82743787 66.365992,7.82743787 69.052214,5.11978426 L72.115274,2.03074021 C74.801958,-0.676913405 79.19758,-0.676913405 81.887036,2.03074021 L84.947324,5.11740181 C87.633238,7.8270408 92.032248,7.8270408 94.718624,5.11740181 L97.78153,2.03074021 C100.467752,-0.676913405 104.864452,-0.676913405 107.553138,2.03074021 L110.613426,5.11740181 C113.302266,7.8270408 117.698658,7.8270408 120.38488,5.11740181 L123.447786,2.03074021 C126.134162,-0.676913405 130.530246,-0.676913405 133.217238,2.03074021 L136.280298,5.11740181 C138.966674,7.8270408 143.362912,7.8270408 146.051752,5.11740181 L149.11435,2.03074021 C150.203951,0.93170321 151.575786,0.277916034 153,0.0714983408 L153,9.92687204e-05 C153.165404,9.92687204e-05 153.330806,0.00601187356 153.495861,0.0178367592 C153.663677,0.0057866107 153.831846,-0.000127020259 154,9.92687204e-05 L154,0.0725499097 C155.423321,0.279975174 156.793877,0.93277591 157.885496,2.03074021 L160.945476,5.11740181 C163.632006,7.8270408 168.030862,7.8270408 170.71693,5.11740181 L173.77999,2.03074021 C176.46652,-0.676913405 180.862758,-0.676913405 183.548826,2.03074021 L186.613888,5.11740181 C189.298416,7.8270408 193.697118,7.8270408 196.38334,5.11740181 L199.445938,2.03074021 C202.134932,-0.676913405 206.531786,-0.676913405 209.217854,2.03074021 L212.280452,5.11978426 C214.969908,7.82743787 219.365992,7.82743787 222.052214,5.11978426 L225.115274,2.03074021 C227.801958,-0.676913405 232.19758,-0.676913405 234.887036,2.03074021 L237.947324,5.11740181 C240.633238,7.8270408 245.032248,7.8270408 247.718624,5.11740181 L250.78153,2.03074021 C253.467752,-0.676913405 257.864452,-0.676913405 260.553138,2.03074021 L263.613426,5.11740181 C266.302266,7.8270408 270.698658,7.8270408 273.38488,5.11740181 L276.447786,2.03074021 C279.134162,-0.676913405 283.530246,-0.676913405 286.217238,2.03074021 L289.280298,5.11740181 C291.966674,7.8270408 296.362912,7.8270408 299.051752,5.11740181 L302.11435,2.03074021 C303.203951,0.93170321 304.575786,0.277916034 306,0.0714983408 L306,9.92687204e-05 C306.165404,9.92687204e-05 306.330806,0.00601187356 306.495861,0.0178367592 C306.663677,0.0057866107 306.831846,-0.000127020259 307,9.92687204e-05 L307,0.0725499097 C308.423321,0.279975174 309.793877,0.93277591 310.885496,2.03074021 L313.945476,5.11740181 C316.632006,7.8270408 321.030862,7.8270408 323.71693,5.11740181 L326.77999,2.03074021 C329.46652,-0.676913405 333.862758,-0.676913405 336.548826,2.03074021 L339.613888,5.11740181 C342.298416,7.8270408 346.697118,7.8270408 349.38334,5.11740181 L352.445938,2.03074021 C355.134932,-0.676913405 359.531786,-0.676913405 362.217854,2.03074021 L365.280452,5.11978426 C367.969908,7.82743787 372.365992,7.82743787 375.052214,5.11978426 L378.115274,2.03074021 C380.801958,-0.676913405 385.19758,-0.676913405 387.887036,2.03074021 L390.947324,5.11740181 C393.633238,7.8270408 398.032248,7.8270408 400.718624,5.11740181 L403.78153,2.03074021 C406.467752,-0.676913405 410.864452,-0.676913405 413.553138,2.03074021 L416.613426,5.11740181 C419.302266,7.8270408 423.698658,7.8270408 426.38488,5.11740181 L429.447786,2.03074021 C432.134162,-0.676913405 436.530246,-0.676913405 439.217238,2.03074021 L442.280298,5.11740181 C444.966674,7.8270408 449.362912,7.8270408 452.051752,5.11740181 L455.11435,2.03074021 C456.203951,0.93170321 457.575786,0.277916034 459,0.0714983408 L459,9.92687204e-05 C459.165404,9.92687204e-05 459.330806,0.00601187356 459.495861,0.0178367592 C459.663677,0.0057866107 459.831846,-0.000127020259 460,9.92687204e-05 L460,0.0725499097 C461.423321,0.279975174 462.793877,0.93277591 463.885496,2.03074021 L466.945476,5.11740181 C469.632006,7.8270408 474.030862,7.8270408 476.71693,5.11740181 L479.77999,2.03074021 C482.46652,-0.676913405 486.862758,-0.676913405 489.548826,2.03074021 L492.613888,5.11740181 C495.298416,7.8270408 499.697118,7.8270408 502.38334,5.11740181 L505.445938,2.03074021 C508.134932,-0.676913405 512.531786,-0.676913405 515.217854,2.03074021 L518.280452,5.11978426 C520.969908,7.82743787 525.365992,7.82743787 528.052214,5.11978426 L531.115274,2.03074021 C533.801958,-0.676913405 538.19758,-0.676913405 540.887036,2.03074021 L543.947324,5.11740181 C546.633238,7.8270408 551.032248,7.8270408 553.718624,5.11740181 L556.78153,2.03074021 C559.467752,-0.676913405 563.864452,-0.676913405 566.553138,2.03074021 L569.613426,5.11740181 C572.302266,7.8270408 576.698658,7.8270408 579.38488,5.11740181 L582.447786,2.03074021 C585.134162,-0.676913405 589.530246,-0.676913405 592.217238,2.03074021 L595.280298,5.11740181 C597.966674,7.8270408 602.362912,7.8270408 605.051752,5.11740181 L608.11435,2.03074021 C609.203951,0.93170321 610.575786,0.277916034 612,0.0714983408 L612,9.92687204e-05 C612.165404,9.92687204e-05 612.330806,0.00601187356 612.495861,0.0178367592 C612.663677,0.0057866107 612.831846,-0.000127020259 613,9.92687204e-05 L613,0.0725499097 C614.423321,0.279975174 615.793877,0.93277591 616.885496,2.03074021 L619.945476,5.11740181 C622.632006,7.8270408 627.030862,7.8270408 629.71693,5.11740181 L632.77999,2.03074021 C635.46652,-0.676913405 639.862758,-0.676913405 642.548826,2.03074021 L645.613888,5.11740181 C648.298416,7.8270408 652.697118,7.8270408 655.38334,5.11740181 L658.445938,2.03074021 C661.134932,-0.676913405 665.531786,-0.676913405 668.217854,2.03074021 L671.280452,5.11978426 C673.969908,7.82743787 678.365992,7.82743787 681.052214,5.11978426 L684.115274,2.03074021 C686.801958,-0.676913405 691.19758,-0.676913405 693.887036,2.03074021 L696.947324,5.11740181 C699.633238,7.8270408 704.032248,7.8270408 706.718624,5.11740181 L709.78153,2.03074021 C712.467752,-0.676913405 716.864452,-0.676913405 719.553138,2.03074021 L722.613426,5.11740181 C725.302266,7.8270408 729.698658,7.8270408 732.38488,5.11740181 L735.447786,2.03074021 C738.134162,-0.676913405 742.530246,-0.676913405 745.217238,2.03074021 L748.280298,5.11740181 C750.966674,7.8270408 755.362912,7.8270408 758.051752,5.11740181 L761.11435,2.03074021 C762.203951,0.93170321 763.575786,0.277916034 765,0.0714983408 L765,9.92687204e-05 C765.165404,9.92687204e-05 765.330806,0.00601187356 765.495861,0.0178367592 C765.663677,0.0057866107 765.831846,-0.000127020259 766,9.92687204e-05 L766,0.0725499097 C767.423321,0.279975174 768.793877,0.93277591 769.885496,2.03074021 L772.945476,5.11740181 C775.632006,7.8270408 780.030862,7.8270408 782.71693,5.11740181 L785.77999,2.03074021 C788.46652,-0.676913405 792.862758,-0.676913405 795.548826,2.03074021 L798.613888,5.11740181 C801.298416,7.8270408 805.697118,7.8270408 808.38334,5.11740181 L811.445938,2.03074021 C814.134932,-0.676913405 818.531786,-0.676913405 821.217854,2.03074021 L824.280452,5.11978426 C826.969908,7.82743787 831.365992,7.82743787 834.052214,5.11978426 L837.115274,2.03074021 C839.801958,-0.676913405 844.19758,-0.676913405 846.887036,2.03074021 L849.947324,5.11740181 C852.633238,7.8270408 857.032248,7.8270408 859.718624,5.11740181 L862.78153,2.03074021 C865.467752,-0.676913405 869.864452,-0.676913405 872.553138,2.03074021 L875.613426,5.11740181 C878.302266,7.8270408 882.698658,7.8270408 885.38488,5.11740181 L888.447786,2.03074021 C891.134162,-0.676913405 895.530246,-0.676913405 898.217238,2.03074021 L901.280298,5.11740181 C903.966674,7.8270408 908.362912,7.8270408 911.051752,5.11740181 L914.11435,2.03074021 C915.457538,0.675920717 917.229616,-0.00228318057 919,9.92687204e-05 C920.769922,9.92687204e-05 922.53969,0.677111942 923.885496,2.03074021 L926.945476,5.11740181 C929.632006,7.8270408 934.030862,7.8270408 936.71693,5.11740181 L939.77999,2.03074021 C942.46652,-0.676913405 946.862758,-0.676913405 949.548826,2.03074021 L952.613888,5.11740181 C955.298416,7.8270408 959.697118,7.8270408 962.38334,5.11740181 L965.445938,2.03074021 C968.134932,-0.676913405 972.531786,-0.676913405 975.217854,2.03074021 L978.280452,5.11978426 C980.969908,7.82743787 985.365992,7.82743787 988.052214,5.11978426 L991.115274,2.03074021 C993.801958,-0.676913405 998.19758,-0.676913405 1000.88704,2.03074021 L1003.94732,5.11740181 C1006.63324,7.8270408 1011.03225,7.8270408 1013.71862,5.11740181 L1016.78153,2.03074021 C1019.46775,-0.676913405 1023.86445,-0.676913405 1026.55314,2.03074021 L1029.61343,5.11740181 C1032.30227,7.8270408 1036.69866,7.8270408 1039.38488,5.11740181 L1042.44779,2.03074021 C1045.13416,-0.676913405 1049.53025,-0.676913405 1052.21724,2.03074021 L1055.2803,5.11740181 C1057.96667,7.8270408 1062.36291,7.8270408 1065.05175,5.11740181 L1068.11435,2.03074021 C1069.20395,0.93170321 1070.57579,0.277916034 1072,0.0714983408 L1072,9.92687204e-05 C1072.1654,9.92687204e-05 1072.33081,0.00601187356 1072.49586,0.0178367592 C1072.66368,0.0057866107 1072.83185,-0.000127020259 1073,9.92687204e-05 L1073,0.0725499097 C1074.42332,0.279975174 1075.79388,0.93277591 1076.8855,2.03074021 L1079.94548,5.11740181 C1082.63201,7.8270408 1087.03086,7.8270408 1089.71693,5.11740181 L1092.77999,2.03074021 C1095.46652,-0.676913405 1099.86276,-0.676913405 1102.54883,2.03074021 L1105.61389,5.11740181 C1108.29842,7.8270408 1112.69712,7.8270408 1115.38334,5.11740181 L1118.44594,2.03074021 C1121.13493,-0.676913405 1125.53179,-0.676913405 1128.21785,2.03074021 L1131.28045,5.11978426 C1133.96991,7.82743787 1138.36599,7.82743787 1141.05221,5.11978426 L1144.11527,2.03074021 C1146.80196,-0.676913405 1151.19758,-0.676913405 1153.88704,2.03074021 L1156.94732,5.11740181 C1159.63324,7.8270408 1164.03225,7.8270408 1166.71862,5.11740181 L1169.78153,2.03074021 C1172.46775,-0.676913405 1176.86445,-0.676913405 1179.55314,2.03074021 L1182.61343,5.11740181 C1185.30227,7.8270408 1189.69866,7.8270408 1192.38488,5.11740181 L1195.44779,2.03074021 C1198.13416,-0.676913405 1202.53025,-0.676913405 1205.21724,2.03074021 L1208.2803,5.11740181 C1210.96667,7.8270408 1215.36291,7.8270408 1218.05175,5.11740181 L1221.11435,2.03074021 C1222.20395,0.93170321 1223.57579,0.277916034 1225,0.0714983408 L1225,9.92687204e-05 C1225.1654,9.92687204e-05 1225.33081,0.00601187356 1225.49586,0.0178367592 C1225.66368,0.0057866107 1225.83185,-0.000127020259 1226,9.92687204e-05 L1226,0.0725499097 C1227.42332,0.279975174 1228.79388,0.93277591 1229.8855,2.03074021 L1232.94548,5.11740181 C1235.63201,7.8270408 1240.03086,7.8270408 1242.71693,5.11740181 L1245.77999,2.03074021 C1248.46652,-0.676913405 1252.86276,-0.676913405 1255.54883,2.03074021 L1258.61389,5.11740181 C1261.29842,7.8270408 1265.69712,7.8270408 1268.38334,5.11740181 L1271.44594,2.03074021 C1274.13493,-0.676913405 1278.53179,-0.676913405 1281.21785,2.03074021 L1284.28045,5.11978426 C1286.96991,7.82743787 1291.36599,7.82743787 1294.05221,5.11978426 L1297.11527,2.03074021 C1299.80196,-0.676913405 1304.19758,-0.676913405 1306.88704,2.03074021 L1309.94732,5.11740181 C1312.63324,7.8270408 1317.03225,7.8270408 1319.71862,5.11740181 L1322.78153,2.03074021 C1325.46775,-0.676913405 1329.86445,-0.676913405 1332.55314,2.03074021 L1335.61343,5.11740181 C1338.30227,7.8270408 1342.69866,7.8270408 1345.38488,5.11740181 L1348.44779,2.03074021 C1351.13416,-0.676913405 1355.53025,-0.676913405 1358.21724,2.03074021 L1361.2803,5.11740181 C1363.96667,7.8270408 1368.36291,7.8270408 1371.05175,5.11740181 L1374.11435,2.03074021 C1375.45754,0.675920717 1377.22962,-0.00228318057 1379,9.92687204e-05 Z"/>
					</svg>';
				break;

			}

			return '<div class="one-row_' . $pos . '_divider" style="height:' . $height . 'px;">' . $svg . '</div>';

		}

	}

	new Liquid_Shape_Divider_Options;

}