<?php

extract( $atts );

$filter_id = uniqid( 'liquid-st-' );

// classes
$classes = array( 
	'liquid-st',
		
	$el_class, 
	$this->get_id() 
);

$this->generate_css();

?>
<div id="<?php echo $this->get_id(); ?>" class="<?php echo $this->sanitize_html_classes( $classes ) ?>">
	
	<form action="#" class="row liquid-st-header">
		
		<div class="col-md-9">
			<header class="section-title">
				<?php $this->get_title(); ?>
				<?php $this->get_description(); ?>
			</header>
		</div><!-- /.col-md-9 -->
		
		<div class="col-md-3 text-right">
			<?php $this->get_filter_cats( $filter_id ); ?>
		</div><!-- /.col-md-3 text-right -->
		
	</form>
	
	<div class="liquid-st-container">
		<div class="liquid-st-inner" data-liquid-schedule-table="true" data-radial-reaction="true" data-filterable-table="true" data-filterable-table-options='{ "filterID": "#<?php echo $filter_id ?>" }'>
			<?php echo do_shortcode( $content ); ?>
		</div><!-- /.liquid-st-inner -->
	</div><!-- /.liquid-st-container -->
	
</div><!-- /.liquid-st -->